FILESEXTRAPATHS_prepend := "${THISDIR}/${BPN}:"
SRC_URI += " \
   ${@d.getVar('TCH_DISTRO', True) == 'tch-cert' and 'file://telnet1.cfg' or ''} \
   ${@d.getVar('TCH_DISTRO', True) == 'tch-cert' and 'file://rdkb_telnetd.cfg' or ''} \
   "
do_configure_append () {
	if [ "${TCH_DISTRO}" = "tch-cert" ]; then
		merge_config.sh -m .config ${WORKDIR}/rdkb_telnetd.cfg
	fi
}
do_install_append () {
       rm  ${D}${systemd_unitdir}/system/busybox-syslog.service
       rm  ${D}${systemd_unitdir}/system/busybox-klogd.service
       #base_libdir doesn't have any other files than systemd files which also got removed by above rm.
       #Hence removing it as kirkstone doesn't allow files/directories if not shipped.
       rm -rf ${D}/${base_libdir}
}

do_install_append () {
       install -d ${D}${base_sbindir}
       ln -sf /bin/busybox.nosuid ${D}${base_sbindir}/syslogd
}

FILES_${PN}-syslog_remove += "${systemd_unitdir}/system/busybox-syslog.service ${systemd_unitdir}/system/busybox-klogd.service"

SYSTEMD_SERVICE_${PN}-syslog_remove += "busybox-syslog.service"
